unit PrinterLib;

interface

function PrinterCreator(model:string):Boolean;
function PortOpen(portSetting:string): Integer;
function PortClose(): Integer;
function PrinterInitialize():Integer;
function FeedLine(lines:integer):Integer;
function PrintText(data:string;alignment:integer;attribute:integer;textSize:integer): Integer;overload;
function PrintText(data:AnsiString): Integer;overload;
function SetTextBold(bold:Integer): Integer;
function SetTextFont(font:integer): Integer;
function PrintBarCode(bcType:integer;data:string;width:integer;height:integer;alignment:integer;hriPosition:integer): Integer;
function PrintSymbol(symbolType:integer;width:Integer;alignment:Integer;symbolData:string):Integer;
function CutPaper(cutMode:integer;distance:integer):Integer;
function PrintImage(imagePath:string;scaleMode:integer): Integer;
function DefineNVImageCompatible(imagePathList:array of string;imageQty:integer): Integer;
function PrintNVImageCompatible(imgNo:integer;scaleMode:integer): Integer;
function DirectIO(writeData:PByte;writeNum:integer;readData:PByte;readNum:integer;preadedNum:PInteger): Integer;


var
//Alignment
ALIGNMENT_LEFT:Integer=0;
ALIGNMENT_CENTER:Integer=1;
ALIGNMENT_RIGHT:Integer=2;
//QR Code Type
SYMBOL_QRCODE1:Integer=103;
SYMBOL_QRCODE2:Integer=104;
//Image ScaleMode
PRINT_IMAGE_NORMAL:Integer=0;
PRINT_IMAGE_DOUBLE_WIDTH:Integer=1;
PRINT_IMAGE_DOUBLE_HEIGHT:Integer=2;
PRINT_IMAGE_QUADRUPLE:Integer=3;
//Font
FONT_A:Integer=0;
FONT_B:Integer=1;
//Cut Paper
FULL_CUT :Integer = 0 ;
PARTIAL_CUT : Integer = 1 ;
//Error Code
E_SUCCESS:Integer=0;
E_BAD_HANDLE:Integer=-6;
//printer
printer:Pointer;
errorNo:Integer=0;



implementation

function PrtPrinterCreatorW(printer: PPointer;model:string): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtPortOpenW(printer: Pointer;portSetting:string): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtPortClose(printer:Pointer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtPrinterInitialize(printer:Pointer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtFeedLine(printer:Pointer;lines:integer): Integer;cdecl ; external 'HprtPrinter.dll';
function PrtPrintTextW(printer:Pointer;data:string;alignment:integer;attribute:integer;textSize:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtPrintTextSA(printer:Pointer;data:AnsiString): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtPrintBarCodeW(printer:Pointer;bcType:integer;data:string;width:integer;height:integer;alignment:integer;hriPosition:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtPrintSymbolW(printer:Pointer;symbolType:integer;symbolData:string;errLevel:Integer;width:Integer;height:Integer;alignment:Integer):Integer;cdecl ; external 'HprtPrinter.dll';
function PrtCutPaper(printer:Pointer;cutMode:integer;distance:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtOpenDrawer(printer:Pointer;pin_mode:integer;onTime:integer;offTime:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtSelectStandardMode(printer:Pointer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtSetTextLineSpace(printer:Pointer;lineSpace:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtSetTextBold(printer:Pointer;bold:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtSetTextFont(printer:Pointer;font:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtSetTextPosition(printer:Pointer;position:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtSelectPageMode(printer:Pointer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtSetPrintAreaInPageMode(printer:Pointer;horizontal:integer;vertical:integer;width:integer;height:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtCancelPrintDataInPageMode(printer:Pointer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtSelectPrintDirectionInPageMode(printer:Pointer;direction:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtSetAbsolutePrintPosition(printer:Pointer;position:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtSetAbsoluteVerticalPrintPositionInPageMode(printer:Pointer;position:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtSetPrintAndReturnStandardMode(printer:Pointer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtPositionNextLabel(printer:Pointer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtPrintDataInPageMode(printer:Pointer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtCheckPrinterState(printer:Pointer;printerStatus:PInteger): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtDirectIO(printer:Pointer;writeData:PByte;writeNum:integer;readData:PByte;readNum:integer;preadedNum:PInteger): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtSetCharacterSet(printer:Pointer;characterSet:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtPrintImageW(printer:Pointer;imagePath:string;scaleMode:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtDefineNVImageCompatibleW(printer:Pointer;imagePathList:array of string;imageQty:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtPrintNVImageCompatible(printer:Pointer;imgNo:integer;scaleMode:integer): Integer; cdecl ; external 'HprtPrinter.dll';
function PrtGetPrinterVersion(printer:Pointer;version:PInteger;versionLen:integer): Integer; cdecl ; external 'HprtPrinter.dll';

function PrinterCreator(model:string):Boolean;
begin
  printer:=nil;
  errorNo:=PrtPrinterCreatorW(@printer,model);
  if(E_SUCCESS=errorNo) then
  begin
    Result :=True;
  end
  else
  begin
    Result := False;
  end;
end;

function PortOpen(portSetting:string): Integer;
begin
  if (printer <> PtrToNil) then
  begin
    Result:= PrtPortOpenW(printer, 'USB');
  end
  else
  begin
    Result := E_BAD_HANDLE;
  end;
end;

function PortClose(): Integer;
begin
  Result := PrtPortClose(printer);
end;

function PrinterInitialize():Integer;
begin
  Result := PrtPrinterInitialize(printer);
end;

function FeedLine(lines:integer):Integer;
begin
  Result := PrtFeedLine(printer,lines);
end;

function PrintText(data:string;alignment:integer;attribute:integer;textSize:integer): Integer;
begin
  Result := PrtPrintTextW(printer,data,alignment,attribute,textSize);
end;

function PrintText(data:AnsiString): Integer;
begin
  Result := PrtPrintTextSA(printer,data);
end;

function PrintBarCode(bcType:integer;data:string;width:integer;height:integer;alignment:integer;hriPosition:integer): Integer;
begin
  Result := PrtPrintBarCodeW(printer,bcType,data,width,height,alignment,hriPosition);
end;

function PrintSymbol(symbolType:integer;width:Integer;alignment:Integer;symbolData:string):Integer;
begin
   Result:=PrtPrintSymbolW(printer,symbolType,symbolData,48,width,0,alignment);
end;

function CutPaper(cutMode:integer;distance:integer):Integer;
begin
  Result := PrtCutPaper(printer,cutMode,distance);
end;

function PrintImage(imagePath:string;scaleMode:integer): Integer;
begin
  Result := PrtPrintImageW(printer,imagePath,scaleMode);
end;

function DefineNVImageCompatible(imagePathList:array of string;imageQty:integer): Integer;
begin
  Result := PrtDefineNVImageCompatibleW(printer,imagePathList,imageQty);
end;

function PrintNVImageCompatible(imgNo:integer;scaleMode:integer): Integer;
begin
  Result := PrtPrintNVImageCompatible(printer,imgNo,scaleMode);
end;

function DirectIO(writeData:PByte;writeNum:integer;readData:PByte;readNum:integer;preadedNum:PInteger): Integer;
begin
  Result := PrtDirectIO(printer,writeData,writeNum,readData,readNum,preadedNum);
end;

function SetTextBold(bold:integer): Integer;
begin
  Result := PrtSetTextBold(printer, bold);
end;

function SetTextFont(font:integer): Integer;
begin
  Result := PrtSetTextFont(printer, font);
end;

end.
